/* Turbo C++ 3.0     */
/* Oswaldo Varela C. */

/* Esta es una contribucin a la educacin de todos aquellos que obtengan
	este archivo. Este cdigo es de dominio pblico, de tal manera que puede
	ser incluido en cualquier aplicacin sin necesidad de contribuciones o
	crditos.
	Para una demostracin de este cdigo ejecute los programas "texto.cpp"
	y "grafico.cpp"*/
#include "dos.h"
#include "conio.h"
#include "stdio.h"
#define ESC		0x1b			/* Define la tecla ESC	*/

//////////////////////////////////////////////////////////////////////////////
//****************** DEFINICION DE CURSORES *********************************
unsigned int C1[] ={ //flecha normal
	0x9FFF,0x8FFF,0x87FF,0x83FF,  //Mascara de pantalla
	0x81FF,0x80FF,0x807F,0x803F,
	0x801F,0x801F,0x80FF,0x887F,
	0x987F,0xFC3F,0xFC3F,0xFE3F,
	0x0000,0x2000,0x3000,0x3800, //Mascara del cursor
	0x3C00,0x3E00,0x3F00,0x3F80,
	0x3FC0,0x3E00,0x3600,0x2300,
	0x0300,0x0180,0x0180,0x0000};
unsigned int C2[] ={ //mano con indice
	0xF3FF,0xE1FF,0xE1FF,0xE1FF,0xE001,0xE000,0xE000,0xE000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0xC003,0x0C00,0x1200,0x1200,0x1200,0x13FE,0x1249,0x1249,0x1249,0x7249,0x9001,0x9001,0x9001,0x8001,0x8001,0x4002,0x3FFC};
unsigned int C3[] ={ //diskette
	0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0FF0,0x0810,0x0FF0,0x0810,0x0FF0,0x0FF0,0x8001,0x7FFE,0x9411,0x9411,0x9411,0x9411,0x8FE1,0x8001,0x8001,0x8FF1,0x9009,0x97E9,0x9009,0x97E9,0x9009,0x9009,0x7FFE};
unsigned int C4[] ={ //cruz
	0xBFFD,0x1FF8,0x8FF1,0xC7E3,0xE3C7,0xF18F,0xF81F,0xFC3F,0xFC3F,0xF81F,0xF18F,0xE3C7,0xC7E3,0x8FF1,0x1FF8,0xBFFD,0x4002,0xE007,0x700E,0x381C,0x1C38,0x0E70,0x07E0,0x03C0,0x03C0,0x07E0,0x0E70,0x1C38,0x381C,0x700E,0xE007,0x4002};
unsigned int C5[] ={ //cruz con colores invertidos
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x4002,0xE007,0x700E,0x381C,0x1C38,0x0E70,0x07E0,0x03C0,0x03C0,0x07E0,0x0E70,0x1C38,0x381C,0x700E,0xE007,0x4002};
unsigned int C6[] ={ //marcador para texto
	0x07FF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0xDFFF,0x07FF,0xFFFF,0xFFFF,0xFFFF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};
unsigned int C7[] ={ //Reloj de arena
	0x001F,0x001F,0x001F,0x803F,0x803F,0xC07F,0xE0FF,0xF1FF,0xF1FF,0xE0FF,0xC07F,0x803F,0x803F,0x001F,0x001F,0x001F,0x0000,0x7FC0,0x0000,0x3F80,0x3780,0x1B00,0x0E00,0x0400,0x0400,0x0E00,0x1B00,0x3580,0x2A80,0x0000,0x7FC0,0x0000};

//****************************************************************************
/////////////////////////////////////////////////////////////////////////////
//************************ objeto MOUSE **************************************
class MOUSE{
	union REGS ireg;
	struct REGPACK res;
	int x,y,der,izq;
	public:
		void cursor(unsigned int mask[]);
		void actualiza();
		void inicia(int,int);
		void datos(int *,int *,int *,int *);
		void limites(int,int,int,int);
		int click(){return(izq);}
		int dclick(){return(der);}
		void hide();
		void show();
};
void MOUSE::hide() {
	ireg.x.ax=2;
	int86(0x33, &ireg, &ireg);
}
void MOUSE::show() {
	ireg.x.ax=1;
	int86(0x33, &ireg, &ireg);
}
//***************** funcion que cambia los limites de accion del mouse *****
void MOUSE::limites(int limx1,int limy1,int limx2, int limy2){
	ireg.x.ax=7;
	ireg.x.cx=limx1;
	ireg.x.dx=limx2;
	int86(0x33, &ireg, &ireg);
	ireg.x.ax=8;
	ireg.x.cx=limy1;
	ireg.x.dx=limy2;
	int86(0x33, &ireg, &ireg);
}
//******************* devuelve datos en punteros ****************************
void MOUSE::datos(int *x1,int *y1,int *izq1,int *der1){
	*x1=x;*y1=y;*izq1=izq;*der1=der;}
//************** cambia puntero del mouse *************************************
void MOUSE::cursor(unsigned int mask[]){
	struct SREGS s;segread(&s);s.es=s.ds;ireg.x.ax=9;ireg.x.bx=1;ireg.x.cx=1;
	ireg.x.dx=(unsigned) mask;int86x(0x33,&ireg,&ireg,&s);hide();show();}
//************ actualiza la posicion actual del raton y botones ***************
void MOUSE::actualiza(){
	res.r_ax = 3;intr(0x33,&res);izq = res.r_bx & 0x01;
	der = res.r_bx & 0x02;der = der >> 1;x = res.r_cx ;y = res.r_dx;
	}
//*************** funcion para inicializar el raton *************************
void MOUSE::inicia(int x,int y) {
	ireg.x.ax=0;
	int86(0x33, &ireg, &ireg);
	ireg.x.ax = 4;
	ireg.x.cx = x;
	ireg.x.dx = y;
	int86(0x33, &ireg, &ireg);
	show();
}
//***************************************************************************
MOUSE mouse; // define objeto mouse fijo
//**************************************************************************

